///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	Contains misc buffer related code.
 *	\file		IceBuffer.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __ICEBUFFER_H__
#define __ICEBUFFER_H__

	ICECORE_API bool Delta(void* buffer, udword nbitems, udword itemsize);
	ICECORE_API bool UnDelta(void* buffer, udword nbitems, udword itemsize);

	ICECORE_API bool DisruptBuffer(void* buffer, udword nbentries, udword itemsize, udword stride);
	ICECORE_API bool SaveAsSource(const String& filename, const String& name, void* buffer, udword length);

	ICECORE_API udword FindRank(udword* sortedlist, udword listsize, udword value);
	ICECORE_API udword SortAndReduce(udword& nb, udword* list, udword* dest=null, Container* cnt=null);

#endif // __ICEBUFFER_H__
